package com.handheld.HFDemo;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import android.app.Activity;
import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentTransaction;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnTouchListener;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import cn.pda.serialport.SerialPort;

import com.handheld.HF.HfManager;
import com.handheld.apiinstructions.R;
import com.handheld.apiinstructions.SettingActivity;

public class HFActivity extends Activity {

	/** Tab UI **/
	private LinearLayout layout14443A;
	private LinearLayout layout15693;
	private TextView textView14443A;
	private TextView textView15693;
	private TextView textView_title_config;
	private View view14443ABar;
	private View view15693Bar;
	
	/** Fragment **/
	private FragmentManager fragManager ;
	private FragmentTransaction fragTran;
	
	private Fragment iso14443AFragment;
	private Fragment iso15693Fragment;
	
	/** serialport **/
	private int port ;
	private int buad ;
	private int powerStr ;
	private static HfManager hf ;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_hf);
		boolean flag14443a = getIntent().getBooleanExtra("14443a", true);
		fragManager = getFragmentManager();
		iso14443AFragment = new ISO14443AFragment();
		iso15693Fragment = new ISO15693Fragment();
		initView();
		if (flag14443a) {
			setTitle(R.string.hf_iso14443a);
			repleaceFragment(iso14443AFragment);
		}else {
			setTitle(R.string.hf_iso15693);
			repleaceFragment(iso15693Fragment);
		}
	}

	private void initView() {
		layout14443A = (LinearLayout) findViewById(R.id.linearLayout14443A);
		layout15693 = (LinearLayout) findViewById(R.id.linearLayout15693);
		textView14443A = (TextView) findViewById(R.id.textViewTab14443a);
		textView15693 = (TextView) findViewById(R.id.textViewTa15693);
		view14443ABar = (View) findViewById(R.id.view14443a);
		view15693Bar = (View) findViewById(R.id.view15693);
		port = getSharedPreferences("serialport", Context.MODE_PRIVATE).getInt("port", 13);
		buad = getSharedPreferences("serialport", Context.MODE_PRIVATE).getInt("buad", 115200);
		powerStr = getSharedPreferences("serialport", Context.MODE_PRIVATE).getInt("power", 4);
		textView_title_config = (TextView) findViewById(R.id.textview_title_config);
		listener();
	}

	private void listener() {
		layout14443A.setOnTouchListener(new OnTouchListener() {

			@Override
			public boolean onTouch(View v, MotionEvent event) {
				Log.e("OnTouchListener", "layout14443A");
				textView14443A.setTextColor(getResources().getColor(R.color.tabSelect));
				view14443ABar.setBackgroundColor(getResources().getColor(R.color.tabSelect));
				textView15693.setTextColor(getResources().getColor(R.color.black));
				view15693Bar.setBackgroundColor(getResources().getColor(R.color.white));
				repleaceFragment(iso14443AFragment);
				return false;
			}
		});
		layout15693.setOnTouchListener(new OnTouchListener() {

			@Override
			public boolean onTouch(View v, MotionEvent event) {
				Log.e("OnTouchListener", "layout15693");
				textView14443A.setTextColor(getResources().getColor(R.color.black));
				view14443ABar.setBackgroundColor(getResources().getColor(R.color.white));
				textView15693.setTextColor(getResources().getColor(R.color.tabSelect));
				view15693Bar.setBackgroundColor(getResources().getColor(R.color.tabSelect));
				repleaceFragment(iso15693Fragment);
				return false;
			}
		});
	}
	
	//Switch Fragment
	private void repleaceFragment(Fragment fragment){
		fragTran = fragManager.beginTransaction();
		fragTran.replace(R.id.layoutFragment, fragment);
		fragTran.commit();
	}
	
	long exitTime = 0L;
	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		if(keyCode == KeyEvent.KEYCODE_BACK){
			if(System.currentTimeMillis() - exitTime < 2000){
				finish();
			}else{
				exitTime = System.currentTimeMillis(); 
				Toast.makeText(this, "Double click to exit!", Toast.LENGTH_SHORT).show();
				return true;
			}
		}
		return super.onKeyDown(keyCode, event);
	}
	
	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		getMenuInflater().inflate(R.menu.main, menu);
		return super.onCreateOptionsMenu(menu);
	}
	private void Modifytheconfiguration(){
		SharedPreferences preference = getSharedPreferences("serialport", Context.MODE_PRIVATE);
		HfManager.Port = preference.getInt(what+"port", SerialPort.com14);
		HfManager.BaudRate = preference.getInt(what+"baudrate", SerialPort.baudrate115200);
		HfManager.Power = preference.getInt(what+"power", SerialPort.Power_Psam);
		String powerString = "";
		switch (HfManager.Power) {
		case SerialPort.Power_3v3:
			powerString = "power_3V3";
			break;
		case SerialPort.Power_5v:
			powerString = "power_5V";
			break;
		case SerialPort.Power_Scaner:
			powerString = "scan_power";
			break;
		case SerialPort.Power_Psam:
			powerString = "psam_power";
			break;
		case SerialPort.Power_Rfid:
			powerString = "rfid_power";
			break;
		default:
			break;
		}
		textView_title_config.setText("Port:com"+HfManager.Port+";Baudrate:"
		+HfManager.BaudRate+";Power:"+powerString);
	}
	@Override
	protected void onResume() {
		Modifytheconfiguration();
		hf = new HfManager() ;
		super.onResume();
	}
	public static HfManager getHfManager() {
		return hf;
	}
	@Override
	protected void onPause() {
		hf.Close();
		super.onPause();
	}
	

	
	public String what = "hf";
	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		if(item.getItemId() == R.id.action_settings){
			Intent intent = new Intent(HFActivity.this, SettingActivity.class);
			intent.putExtra("what", what);
			startActivity(intent);
		}
		return super.onOptionsItemSelected(item);
	}
	

}
